<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title><?php echo e($title); ?></title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Free HTML Templates" name="keywords">
    <meta content="Free HTML Templates" name="description">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('assets/')); ?>/mm.svg" type="image/png">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="<?php echo e(asset('assets/publics')); ?>/lib/animate/animate.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('assets/publics')); ?>/lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/')); ?>/admin/plugins/sweetalert2/sweetalert2.min.css">
    <link href="<?php echo e(asset('assets/publics')); ?>/css/style.css" rel="stylesheet">
    <?php echo e($slot); ?>

    <style>
    /* ===== GLOBAL HEADER STYLE ===== */
    :root {
        --primary: #2563eb;
        --secondary: #9333ea;
        --danger: #dc2626;
    }

    /* Topbar gradient */
    .topbar-gradient {
        background: linear-gradient(90deg, var(--primary), var(--secondary));
    }

    .topbar-gradient a {
        color: #fff !important;
        font-weight: 500;
        transition: all .3s ease;
    }

    .topbar-gradient a:hover {
        text-decoration: underline;
        opacity: .85;
    }

    /* Navbar gradient */
    .navbar-gradient {
        background: linear-gradient(90deg, #dc2626, #ef4444);
    }

    /* Logo */
    .site-logo {
        max-height: 55px;
        transition: transform .3s ease;
    }

    .site-logo:hover {
        transform: scale(1.05);
    }

    /* Menu mobile */
    #menu a {
        background: rgba(255,255,255,.15);
        color: #fff;
        padding: 6px 12px;
        border-radius: 20px;
        font-weight: 500;
        transition: all .3s ease;
    }

    #menu a:hover {
        background: #fff;
        color: #dc2626;
    }

    /* Cart badge */
    .cart-badge {
        background: #fff;
        color: #dc2626;
        font-weight: bold;
    }
</style>

</head>

<body>
    <!-- Topbar Start -->
    <div class="container-fluid">
      <div class="row topbar-gradient py-2 px-xl-5">

            <div class="col-lg-6 d-none d-lg-block head-contact">
                <div class="d-inline-flex align-items-center h-100">
                    <a class="text-body tw mr-3 " href="/">Beranda</a>
                    <a class="text-body tw mr-3 " href="/tentang">Tentang Kami</a>
                    <a class="text-body tw mr-3 " href="/list-produk">Produk </a>
                    <a class="text-body tw mr-3 " href="/layanan">Layanan </a>
                    <a class="text-body tw mr-3 " href="/kontak">Kontak</a>
                    
                </div>
            </div>
            <div class="col-lg-6 text-center text-lg-right">
                <div class="d-inline-flex align-items-center">

                    <?php if(Auth::guard('member')->check()): ?>
                        <a href="/logout-member" class="btn btn-danger 0 ml-2">
                            
                            Logout
                        </a>
                        <a href="/akun" class="btn  px-0 ml-2">
                            <span class="badge tw border border-dark rounded-circle"
                                style="padding-bottom: 2px;">Akun</span>
                            <i class="fas tw fa-user-circle text-dark"></i>
                        </a>
                    <?php else: ?>
                        <a href="/daftar" class="btn btn-info 0 ml-2">
                            
                            Daftar
                        </a>

                        <a href="/login" class="btn btn-warning 0 ml-2">
                            
                            Login
                        </a>
                    <?php endif; ?>

                </div>
                <div class="d-inline-flex align-items-center d-block d-lg-none">

                    <a href="/keranjang" class="btn  px-0 ml-2">
                        <i class="fas tw fa-shopping-cart text-dark"></i>
                        <span class="badge text-danger border border-white rounded-circle"
                            style="padding-bottom: 2px;"><span id="isi_cart1"><?php echo e(Cart::count()); ?></span></span>
                    </a>
                </div>
            </div>
        </div>
        <div class="row align-items-center bg-light py-3 px-xl-5 d-none d-lg-flex">
            <div class="col-lg-4">
                <a href="/" class="text-decoration-none">
                  <img src="<?php echo e(asset('assets/publics/ramizah.png')); ?>" 
     alt="Logo" 
     class="site-logo">

                </a>
            </div>
            <div class="col-lg-6 col-6 text-left">
                <form action="list-produk?cari=">
                    <div class="input-group">
                        <input type="text" class="form-control form-control-lg" placeholder="Search...."
                            name="cari">
                        <div class="input-group-append">
                            <span class="input-group-text bg-transparent text-danger">
                                <i class="fa fa-search"></i>
                            </span>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-lg-2 col-6 text-right">
                <div class="navbar-nav ml-auto py-0 d-none d-lg-block">

                    <a href="/keranjang" class="btn px-0 ml-3">
                        <i class="fas fa-shopping-cart text-dark fw-lg"></i>
                        <span class="badge text-dark border border-danger rounded-circle" style="padding-bottom: 2px;">
                            <span id="isi_cart2"><?php echo e(Cart::count()); ?></span>
                        </span>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <!-- Topbar End -->


    <!-- Navbar Start -->
    <div class="container-fluid bg-primary">
        <div class="row">
            <div class="col-lg-12  d-lg-none " id="menu">
                <a href="/home">Beranda </a>
                <a href="/tentang">About </a>
                <a href="/list-produk">Produk</a>
                <a href="/layanan">Layanan</a>
                <a href="/kontak">Kontak</a>
            </div>
            <div class="col-lg-12  d-none d-lg-flex">
                <br>
            </div>
        </div>
    </div>
    <div class="container-fluid bg-danger mb-30">
        <div class="row px-xl-5">
            
            <div class="col-lg-9">
               <nav class="navbar navbar-expand-lg navbar-dark navbar-gradient py-3 py-lg-0 px-0">

                    <a href="/" class="text-decoration-none d-block d-lg-none">
                       <img src="<?php echo e(asset('assets/publics/ramizah.png')); ?>" 
     alt="Logo" 
     class="site-logo">

                    </a>
                    <br>
                    <button type="button" class="navbar-toggler" data-toggle="modal" data-target="#cariproduk">
                        
                        <i class="fa fa-search tw"></i>
                    </button>
                    
                </nav>
            </div>
        </div>
    </div>
    <!-- Navbar End -->

    <div class="modal" id="cariproduk" style="margin-top: 50px;">
        <div class="modal-dialog">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header">

                </div>

                <!-- Modal body -->
                <div class="modal-body">
                    <form action="list-produk?cari=">
                        <div class="input-group">
                            <input type="text" class="form-control form-control-lg" placeholder="Search...."
                                name="cari">
                            <div class="input-group-append">
                                <button class="input-group-text bg-transparent text-danger">
                                    <i class="fa fa-search"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>

                <!-- Modal footer -->
                <div class="modal-footer">
                    
                </div>

            </div>
        </div>
    </div>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/e-CommerceLv11/resources/views/components/user/header.blade.php ENDPATH**/ ?>